import http from 'k6/http';
import { check, sleep } from 'k6';

export const options = {
  stages: [
    { duration: '10s', target: 10 },   // Normal load
    { duration: '30s', target: 500 },  // Sudden spike!
    { duration: '1m', target: 500 },   // Sustained spike
    { duration: '10s', target: 10 },   // Recovery
  ],
  thresholds: {
    http_req_duration: ['p(95)<2000'], // More lenient during spikes
    http_req_failed: ['rate<0.1'],     // Allow 10% errors during spike
  },
};

export default function () {
  const res = http.get('https://api.example.com/health');

  check(res, {
    'status is 200': (r) => r.status === 200,
    'response time OK': (r) => r.timings.duration < 3000,
  });

  sleep(Math.random() * 2); // Random think time
}
