import http from 'k6/http';
import { check, sleep } from 'k6';
import { Rate } from 'k6/metrics';

const rateLimitHit = new Rate('rate_limit_hit');

export const options = {
  scenarios: {
    rate_limit_test: {
      executor: 'constant-arrival-rate',
      rate: 100,           // 100 requests per timeUnit
      timeUnit: '1s',
      duration: '1m',
      preAllocatedVUs: 50,
      maxVUs: 100,
    },
  },
};

export default function () {
  const res = http.get('https://api.example.com/data');

  check(res, {
    'success': (r) => r.status === 200,
    'rate limited': (r) => r.status === 429,
  });

  // Track rate limiting
  rateLimitHit.add(res.status === 429);

  if (res.status === 429) {
    const retryAfter = res.headers['Retry-After'] || 1;
    console.log(`Rate limited. Retry after ${retryAfter}s`);
  }

  sleep(0.1);
}
