import http from 'k6/http';
import { check, group, sleep } from 'k6';

export const options = {
  stages: [
    { duration: '1m', target: 30 },
    { duration: '3m', target: 30 },
    { duration: '1m', target: 0 },
  ],
  thresholds: {
    'group_duration{group:::User Journey}': ['p(95)<5000'],
    http_req_duration: ['p(95)<500'],
  },
};

export default function () {
  group('User Journey', function () {
    // 1. Browse products
    let res = http.get('https://api.example.com/products');
    check(res, { 'products loaded': (r) => r.status === 200 });
    sleep(1);

    // 2. View product details
    res = http.get('https://api.example.com/products/123');
    check(res, { 'product details loaded': (r) => r.status === 200 });
    sleep(2);

    // 3. Add to cart
    const cartPayload = JSON.stringify({ productId: 123, quantity: 1 });
    res = http.post('https://api.example.com/cart', cartPayload, {
      headers: { 'Content-Type': 'application/json' },
    });
    check(res, { 'added to cart': (r) => r.status === 201 });
    sleep(1);

    // 4. Checkout
    const checkoutPayload = JSON.stringify({
      paymentMethod: 'card',
      address: '123 Main St',
    });
    res = http.post('https://api.example.com/checkout', checkoutPayload, {
      headers: { 'Content-Type': 'application/json' },
    });
    check(res, { 'checkout success': (r) => r.status === 200 });
  });

  sleep(3);
}
