import http from 'k6/http';
import { check, sleep } from 'k6';

export const options = {
  vus: 30,
  duration: '2m',
  thresholds: {
    http_req_duration: ['p(95)<800'],
  },
};

export default function () {
  const query = `
    query GetUserProfile($userId: ID!) {
      user(id: $userId) {
        id
        name
        email
        posts(limit: 10) {
          id
          title
          comments {
            id
            text
            author {
              name
            }
          }
        }
      }
    }
  `;

  const variables = {
    userId: Math.floor(Math.random() * 1000) + 1,
  };

  const payload = JSON.stringify({ query, variables });

  const params = {
    headers: {
      'Content-Type': 'application/json',
      'Authorization': 'Bearer YOUR_TOKEN_HERE',
    },
  };

  const res = http.post('https://api.example.com/graphql', payload, params);

  check(res, {
    'query successful': (r) => r.status === 200,
    'no errors': (r) => !JSON.parse(r.body).errors,
    'has user data': (r) => JSON.parse(r.body).data.user !== null,
  });

  sleep(1);
}
