import http from 'k6/http';
import { check, sleep } from 'k6';

export const options = {
  stages: [
    { duration: '2m', target: 100 },  // Ramp up to 100 users
    { duration: '5m', target: 100 },  // Stay at 100 users
    { duration: '2m', target: 200 },  // Ramp up to 200 users
    { duration: '5m', target: 200 },  // Stay at 200 users
    { duration: '2m', target: 0 },    // Ramp down
  ],
  thresholds: {
    http_req_duration: ['p(99)<1000', 'p(95)<800', 'p(50)<400'],
    http_req_failed: ['rate<0.05'],
  },
};

export default function () {
  const url = 'https://api.example.com/products?page=1&limit=20';

  const params = {
    headers: {
      'Accept': 'application/json',
      'Authorization': 'Bearer YOUR_TOKEN_HERE',
    },
  };

  const res = http.get(url, params);

  check(res, {
    'status is 200': (r) => r.status === 200,
    'has products array': (r) => {
      const body = JSON.parse(r.body);
      return Array.isArray(body.products);
    },
    'response size ok': (r) => r.body.length < 100000,
  });

  sleep(0.5);
}
