import http from 'k6/http';
import { check, sleep } from 'k6';
import { SharedArray } from 'k6/data';

const file = open('./test-file.pdf', 'b'); // Binary file

export const options = {
  vus: 10,
  duration: '1m',
  thresholds: {
    http_req_duration: ['p(95)<3000'], // Uploads can be slower
  },
};

export default function () {
  const formData = {
    file: http.file(file, 'test-file.pdf', 'application/pdf'),
    description: 'Test file upload',
    category: 'documents',
  };

  const res = http.post('https://api.example.com/upload', formData, {
    headers: {
      'Authorization': 'Bearer YOUR_TOKEN_HERE',
    },
  });

  check(res, {
    'upload successful': (r) => r.status === 201,
    'has file id': (r) => JSON.parse(r.body).fileId !== undefined,
    'upload time reasonable': (r) => r.timings.duration < 5000,
  });

  sleep(2);
}
