import http from 'k6/http';
import { check, sleep } from 'k6';

export const options = {
  vus: 20,
  duration: '2m',
  thresholds: {
    http_req_duration: ['p(95)<600'],
  },
};

// Login once per VU
export function setup() {
  const loginRes = http.post('https://api.example.com/auth/login', JSON.stringify({
    username: 'testuser',
    password: 'testpass123',
  }), {
    headers: { 'Content-Type': 'application/json' },
  });

  return { token: JSON.parse(loginRes.body).token };
}

export default function (data) {
  const params = {
    headers: {
      'Content-Type': 'application/json',
      'Authorization': `Bearer ${data.token}`,
    },
  };

  // Create a post
  const payload = JSON.stringify({
    title: 'Test Post',
    content: 'This is a test post content',
  });

  const res = http.post('https://api.example.com/posts', payload, params);

  check(res, {
    'post created': (r) => r.status === 201,
    'has post id': (r) => JSON.parse(r.body).id !== undefined,
  });

  sleep(2);
}
