package com.automation.utils;

import org.apache.poi.ss.usermodel.IndexedColors;

/**
 * Constants for Excel Utility
 * Provides commonly used values and color codes
 *
 * @author DevTools
 * @version 1.0
 */
public class ExcelConstants {

    // Common Sheet Names
    public static final String SHEET_TEST_DATA = "TestData";
    public static final String SHEET_TEST_RESULTS = "TestResults";
    public static final String SHEET_CONFIG = "Config";
    public static final String SHEET_USERS = "Users";

    // Test Result Values
    public static final String RESULT_PASS = "PASS";
    public static final String RESULT_FAIL = "FAIL";
    public static final String RESULT_SKIP = "SKIP";
    public static final String RESULT_BLOCKED = "BLOCKED";
    public static final String RESULT_NOT_EXECUTED = "NOT EXECUTED";

    // Common Column Headers
    public static final String COL_TEST_CASE_ID = "TestCaseID";
    public static final String COL_TEST_CASE_NAME = "TestCaseName";
    public static final String COL_DESCRIPTION = "Description";
    public static final String COL_EXPECTED_RESULT = "ExpectedResult";
    public static final String COL_ACTUAL_RESULT = "ActualResult";
    public static final String COL_STATUS = "Status";
    public static final String COL_REMARKS = "Remarks";
    public static final String COL_EXECUTED_BY = "ExecutedBy";
    public static final String COL_EXECUTION_DATE = "ExecutionDate";

    // User Data Headers
    public static final String COL_USERNAME = "Username";
    public static final String COL_PASSWORD = "Password";
    public static final String COL_EMAIL = "Email";
    public static final String COL_ROLE = "Role";
    public static final String COL_RUN_MODE = "RunMode";

    // Run Mode Values
    public static final String RUN_MODE_YES = "Yes";
    public static final String RUN_MODE_NO = "No";
    public static final String RUN_MODE_Y = "Y";
    public static final String RUN_MODE_N = "N";

    // Color Codes (IndexedColors)
    public static final short COLOR_HEADER_BG = IndexedColors.DARK_BLUE.getIndex();
    public static final short COLOR_HEADER_FONT = IndexedColors.WHITE.getIndex();
    public static final short COLOR_PASS_BG = IndexedColors.GREEN.getIndex();
    public static final short COLOR_PASS_FONT = IndexedColors.WHITE.getIndex();
    public static final short COLOR_FAIL_BG = IndexedColors.RED.getIndex();
    public static final short COLOR_FAIL_FONT = IndexedColors.WHITE.getIndex();
    public static final short COLOR_SKIP_BG = IndexedColors.YELLOW.getIndex();
    public static final short COLOR_SKIP_FONT = IndexedColors.BLACK.getIndex();
    public static final short COLOR_BLOCKED_BG = IndexedColors.ORANGE.getIndex();
    public static final short COLOR_BLOCKED_FONT = IndexedColors.WHITE.getIndex();

    // Font Sizes
    public static final short FONT_SIZE_HEADER = 12;
    public static final short FONT_SIZE_NORMAL = 11;
    public static final short FONT_SIZE_SMALL = 9;
    public static final short FONT_SIZE_LARGE = 14;

    // Default Column Widths (in characters)
    public static final int WIDTH_ID = 15;
    public static final int WIDTH_NAME = 30;
    public static final int WIDTH_DESCRIPTION = 50;
    public static final int WIDTH_STATUS = 12;
    public static final int WIDTH_DATE = 20;
    public static final int WIDTH_REMARKS = 40;

    // File Extensions
    public static final String EXT_XLSX = ".xlsx";
    public static final String EXT_XLS = ".xls";

    // Default Paths (can be customized)
    public static final String DEFAULT_TEST_DATA_PATH = "src/test/resources/testdata/";
    public static final String DEFAULT_TEST_RESULTS_PATH = "test-output/excel-reports/";

    // Common Error Messages
    public static final String ERROR_FILE_NOT_FOUND = "Excel file not found at path: ";
    public static final String ERROR_SHEET_NOT_FOUND = "Sheet not found: ";
    public static final String ERROR_INVALID_FORMAT = "Invalid file format. Use .xlsx or .xls";
    public static final String ERROR_READ_FAILED = "Failed to read data from Excel";
    public static final String ERROR_WRITE_FAILED = "Failed to write data to Excel";

    // Private constructor to prevent instantiation
    private ExcelConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}
