<?php
// Configuration
$secret = getenv('WEBHOOK_SECRET') ?: 'your_secret';
$deploy_script = '/path/to/deploy.sh';
$log_file = '/var/log/github-webhook.log';

// Read payload
$payload = file_get_contents("php://input");
$signature = $_SERVER["HTTP_X_HUB_SIGNATURE_256"] ?? "";
$event = $_SERVER["HTTP_X_GITHUB_EVENT"] ?? "unknown";

// Log request
file_put_contents($log_file, date('Y-m-d H:i:s') . " - Event: $event\n", FILE_APPEND);

// Verify signature
$hash = "sha256=" . hash_hmac("sha256", $payload, $secret);
if (!hash_equals($hash, $signature)) {
    http_response_code(401);
    file_put_contents($log_file, "Invalid signature\n", FILE_APPEND);
    exit("Invalid signature");
}

// Handle push event
if ($event === "push") {
    $data = json_decode($payload, true);
    $branch = $data['ref'] ?? '';

    file_put_contents($log_file, "Push to: $branch\n", FILE_APPEND);

    // Execute deployment script
    $output = shell_exec("sh $deploy_script 2>&1");
    file_put_contents($log_file, "Deploy output: $output\n", FILE_APPEND);
}

http_response_code(200);
echo "OK";
?>
