<?php
function verifyGitHubSignature($payload, $signature, $secret) {
    if (empty($signature)) {
        return false;
    }

    $hash = "sha256=" . hash_hmac("sha256", $payload, $secret);
    return hash_equals($hash, $signature);
}

// Usage
$payload = file_get_contents("php://input");
$signature = $_SERVER["HTTP_X_HUB_SIGNATURE_256"] ?? "";
$secret = "your_webhook_secret";

if (!verifyGitHubSignature($payload, $signature, $secret)) {
    http_response_code(401);
    exit("Invalid signature");
}
?>
