#!/bin/bash

# GitHub Webhook Deployment Script
# This script is executed by webhook.php on push events

# Configuration
REPO_DIR="/var/www/html"
BRANCH="main"
LOG_FILE="/var/log/deploy.log"

# Timestamp
echo "[$(date '+%Y-%m-%d %H:%M:%S')] Starting deployment..." | tee -a "$LOG_FILE"

# Navigate to repository
cd "$REPO_DIR" || exit 1

# Fetch latest changes
echo "Fetching from origin..." | tee -a "$LOG_FILE"
git fetch origin "$BRANCH" 2>&1 | tee -a "$LOG_FILE"

# Pull changes
echo "Pulling branch $BRANCH..." | tee -a "$LOG_FILE"
git pull origin "$BRANCH" 2>&1 | tee -a "$LOG_FILE"

# Optional: Install dependencies
# echo "Installing dependencies..." | tee -a "$LOG_FILE"
# composer install --no-dev --optimize-autoloader 2>&1 | tee -a "$LOG_FILE"
# npm install --production 2>&1 | tee -a "$LOG_FILE"

# Optional: Build assets
# echo "Building assets..." | tee -a "$LOG_FILE"
# npm run build 2>&1 | tee -a "$LOG_FILE"

# Optional: Clear cache
# echo "Clearing cache..." | tee -a "$LOG_FILE"
# php artisan cache:clear 2>&1 | tee -a "$LOG_FILE"

echo "[$(date '+%Y-%m-%d %H:%M:%S')] Deployment completed!" | tee -a "$LOG_FILE"
exit 0
