import crypto from "crypto";
import http from "http";

const SECRET = process.env.SECRET || "your_secret";
const PORT = process.env.PORT || 3001;

function verifySignature(signature, payload) {
  if (!signature) return false;

  const hmac = crypto.createHmac("sha256", SECRET);
  const digest = "sha256=" + hmac.update(payload).digest("hex");

  return signature === digest;
}

http.createServer((req, res) => {
  if (req.method !== "POST" || req.url !== "/webhook") {
    res.writeHead(404);
    return res.end("Not Found");
  }

  let body = [];
  req.on("data", chunk => body.push(chunk));
  req.on("end", () => {
    const payload = Buffer.concat(body).toString();
    const signature = req.headers["x-hub-signature-256"];

    if (!verifySignature(signature, payload)) {
      res.writeHead(401);
      return res.end("Invalid");
    }

    if (req.headers["x-github-event"] === "push") {
      require("child_process").exec("sh /path/to/deploy.sh");
    }

    res.end("OK");
  });
}).listen(PORT, () => {
  console.log(`GitHub webhook server running on port ${PORT}`);
});
