import crypto from "crypto";
import express from "express";

const app = express();
const SECRET = process.env.SECRET || "your_secret";
const PORT = process.env.PORT || 3000;

app.use(express.raw({ type: "application/json" }));

function verifySignature(req) {
  const signature = req.headers["x-hub-signature-256"];
  const hmac = crypto.createHmac("sha256", SECRET);
  const digest = "sha256=" + hmac.update(req.body).digest("hex");
  return signature === digest;
}

app.post("/webhook", (req, res) => {
  if (!verifySignature(req)) {
    return res.status(401).send("Invalid");
  }

  const event = req.headers["x-github-event"];
  if (event === "push") {
    require("child_process").exec("sh /path/to/deploy.sh");
  }

  res.send("OK");
});

app.listen(PORT, () => {
  console.log(`GitHub webhook server running on port ${PORT}`);
});
