#!/bin/bash

# GitHub Webhook Deployment Script
# This script is triggered by the webhook handler when a push event occurs

set -e  # Exit on error

# Configuration
PROJECT_DIR="/path/to/your/project"
BRANCH="main"
PM2_APP_NAME="github-webhook"

# Log file
LOG_FILE="/var/log/webhook-deploy.log"

# Function to log messages
log() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

log "====== Deployment Started ======"

# Navigate to project directory
cd "$PROJECT_DIR" || exit 1
log "Changed to directory: $PROJECT_DIR"

# Fetch latest changes
log "Fetching latest changes from origin..."
git fetch origin

# Reset to latest commit on branch
log "Resetting to origin/$BRANCH..."
git reset --hard "origin/$BRANCH"

# Install/update dependencies
if [ -f "package.json" ]; then
    log "Installing/updating dependencies..."
    npm install --production
fi

# Restart PM2 application
log "Restarting PM2 application: $PM2_APP_NAME"
pm2 restart "$PM2_APP_NAME" || pm2 start ecosystem.config.js

log "====== Deployment Completed Successfully ======"
