#!/bin/bash

# GitHub Webhook Deployment Script
# This script is triggered when a webhook event is received

set -e

# Configuration
REPO_DIR="/path/to/your/repository"
BRANCH="main"
LOG_FILE="/var/log/webhook-deploy.log"

# Function to log messages
log() {
    echo "[$(date '+%Y-%m-%d %H:%M:%S')] $1" | tee -a "$LOG_FILE"
}

log "Starting deployment..."

# Navigate to repository directory
cd "$REPO_DIR" || exit 1

# Pull latest changes
log "Pulling latest changes from $BRANCH..."
git fetch origin
git reset --hard "origin/$BRANCH"

# Install dependencies (if needed)
log "Installing dependencies..."
# Uncomment the appropriate command for your project:
# mvn clean install
# npm install
# pip install -r requirements.txt

# Build the project
log "Building project..."
# Uncomment the appropriate command for your project:
# mvn package
# npm run build
# docker build -t myapp .

# Restart the application
log "Restarting application..."
# Uncomment the appropriate command for your setup:
# systemctl restart myapp
# docker-compose restart
# pm2 restart myapp

log "Deployment completed successfully!"
