import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacUtils;

public class WebhookVerifier {

    private final String secret;

    public WebhookVerifier(String secret) {
        this.secret = secret;
    }

    /**
     * Verify GitHub webhook signature using HMAC SHA-256
     *
     * @param signature The signature from X-Hub-Signature-256 header
     * @param payload The raw request body payload
     * @return true if signature is valid, false otherwise
     */
    public boolean verifySignature(String signature, String payload) {
        if (signature == null) return false;

        String expected = "sha256=" +
            Hex.encodeHexString(HmacUtils.hmacSha256(secret, payload));

        return expected.equals(signature);
    }
}
