import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacUtils;
import java.io.BufferedReader;
import java.io.IOException;

@RestController
public class GithubWebhookController {

    private static final String SECRET = "YOUR_WEBHOOK_SECRET";

    @PostMapping("/webhook")
    public String handleWebhook(HttpServletRequest request) throws IOException {

        // Read payload
        StringBuilder payload = new StringBuilder();
        try (BufferedReader reader = request.getReader()) {
            String line;
            while ((line = reader.readLine()) != null) {
                payload.append(line);
            }
        }

        // Verify signature (X-Hub-Signature-256)
        String signature = request.getHeader("X-Hub-Signature-256");
        if (!verifySignature(signature, payload.toString())) {
            return "Invalid signature";
        }

        String event = request.getHeader("X-GitHub-Event");

        if ("push".equals(event)) {
            // Execute deployment script or command
            runDeployScript();
        }

        return "OK";
    }

    private boolean verifySignature(String signature, String payload) {
        if (signature == null) return false;

        String expected = "sha256=" +
                Hex.encodeHexString(HmacUtils.hmacSha256(SECRET, payload));

        return expected.equals(signature);
    }

    private void runDeployScript() {
        try {
            ProcessBuilder pb = new ProcessBuilder(
                "/bin/bash", "/path/to/deploy.sh"
            );
            pb.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
